<?php
/* --------------------------------------------------------------
   AllWithdrawalsRequested.php 2020-03-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\Events;

use Gambio\Admin\Withdrawal\Interfaces\WithdrawalSqlCriteria;
use Gambio\Admin\Withdrawal\Interfaces\WithdrawalSqlPagination;

/**
 * Class AllWithdrawalsRequested
 *
 * @package Gambio\Admin\Withdrawal\Events
 */
class AllWithdrawalsRequested
{
    /**
     * @var WithdrawalSqlCriteria
     */
    private $criteria;
    
    
    /**
     * @var WithdrawalSqlPagination
     */
    private $pagination;
    
    
    /**
     * AllWithdrawalsRequested constructor.
     *
     * @param WithdrawalSqlCriteria   $criteria
     * @param WithdrawalSqlPagination $pagination
     */
    private function __construct(WithdrawalSqlCriteria $criteria, WithdrawalSqlPagination $pagination)
    {
        $this->criteria   = $criteria;
        $this->pagination = $pagination;
    }
    
    
    /**
     * @param WithdrawalSqlCriteria   $criteria
     * @param WithdrawalSqlPagination $pagination
     *
     * @return AllWithdrawalsRequested
     */
    public static function create(
        WithdrawalSqlCriteria $criteria,
        WithdrawalSqlPagination $pagination
    ): AllWithdrawalsRequested {
        return new self($criteria, $pagination);
    }
    
    
    /**
     * @return WithdrawalSqlCriteria
     */
    public function criteria(): WithdrawalSqlCriteria
    {
        return $this->criteria;
    }
    
    
    /**
     * @return WithdrawalSqlPagination
     */
    public function pagination(): WithdrawalSqlPagination
    {
        return $this->pagination;
    }
    
    
    /**
     * @param WithdrawalSqlCriteria $criteria
     */
    public function replaceCriteria(WithdrawalSqlCriteria $criteria): void
    {
        $this->criteria = $criteria;
    }
    
    
    /**
     * @param WithdrawalSqlPagination $pagination
     */
    public function replacePagination(WithdrawalSqlPagination $pagination): void
    {
        $this->pagination = $pagination;
    }
}